

<?php $__env->startSection('title', 'Doctor Dashboard'); ?>

<?php $__env->startSection('content'); ?>
<div class="max-w-7xl mx-auto px-2 sm:px-4 lg:px-8">
    <h1 class="text-2xl sm:text-3xl font-bold text-gray-800 mb-4 sm:mb-6">Doctor Dashboard</h1>

    <!-- Quick Actions -->
    <div class="mb-4 sm:mb-6 flex flex-wrap gap-2">
        <a href="<?php echo e(route('doctor.availability')); ?>" class="bg-purple-600 hover:bg-purple-700 text-white px-4 py-2 rounded text-sm sm:text-base">
            <i class="fas fa-calendar-alt"></i> <span class="hidden sm:inline">Manage Availability</span><span class="sm:hidden">Availability</span>
        </a>
        <a href="<?php echo e(route('doctor.profile')); ?>" class="bg-gray-600 hover:bg-gray-700 text-white px-4 py-2 rounded text-sm sm:text-base">
            <i class="fas fa-user"></i> <span class="hidden sm:inline">My Profile</span><span class="sm:hidden">Profile</span>
        </a>
    </div>

    <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-4 sm:gap-6 mb-6 sm:mb-8">
        <div class="bg-white rounded-lg shadow p-6">
            <div class="flex items-center">
                <div class="p-3 bg-blue-100 rounded-full">
                    <i class="fas fa-calendar text-blue-600 text-2xl"></i>
                </div>
                <div class="ml-2 sm:ml-4">
                    <p class="text-xs sm:text-sm text-gray-600">Total Appointments</p>
                    <p class="text-xl sm:text-2xl font-bold"><?php echo e($stats['appointments']); ?></p>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-lg shadow p-6">
            <div class="flex items-center">
                <div class="p-3 bg-yellow-100 rounded-full">
                    <i class="fas fa-clock text-yellow-600 text-2xl"></i>
                </div>
                <div class="ml-2 sm:ml-4">
                    <p class="text-xs sm:text-sm text-gray-600">Pending Appointments</p>
                    <p class="text-xl sm:text-2xl font-bold"><?php echo e($stats['pending_appointments']); ?></p>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-lg shadow p-6">
            <div class="flex items-center">
                <div class="p-3 bg-green-100 rounded-full">
                    <i class="fas fa-prescription text-green-600 text-2xl"></i>
                </div>
                <div class="ml-2 sm:ml-4">
                    <p class="text-xs sm:text-sm text-gray-600">Prescriptions</p>
                    <p class="text-xl sm:text-2xl font-bold"><?php echo e($stats['prescriptions']); ?></p>
                </div>
            </div>
        </div>
    </div>

    <!-- Notifications Section -->
    <?php if($notifications->count() > 0): ?>
    <div class="bg-white rounded-lg shadow p-4 sm:p-6 mb-4 sm:mb-6">
        <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center mb-3 sm:mb-4 gap-2">
            <h2 class="text-lg sm:text-xl font-bold">Notifications</h2>
            <form method="POST" action="<?php echo e(route('doctor.notifications.mark-all-read')); ?>" class="inline">
                <?php echo csrf_field(); ?>
                <button type="submit" class="text-xs sm:text-sm text-blue-600 hover:text-blue-900">Mark all as read</button>
            </form>
        </div>
        <div class="space-y-3">
            <?php $__currentLoopData = $notifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="border-l-4 border-blue-500 bg-blue-50 p-4 rounded">
                <div class="flex justify-between items-start">
                    <div class="flex-1">
                        <p class="font-semibold text-gray-800"><?php echo e($notification->data['message'] ?? 'New notification'); ?></p>
                        <?php if(isset($notification->data['appointment_id'])): ?>
                            <p class="text-sm text-gray-600 mt-1">
                                Patient: <?php echo e($notification->data['patient_name'] ?? 'N/A'); ?> | 
                                Type: <?php echo e($notification->data['consultation_type'] ?? 'N/A'); ?>

                            </p>
                            <div class="mt-2 flex flex-col sm:flex-row gap-2">
                                <a href="<?php echo e(route('doctor.appointments')); ?>" class="text-xs sm:text-sm text-blue-600 hover:text-blue-900">View Appointment</a>
                                <?php if(isset($notification->data['appointment_id'])): ?>
                                    <a href="<?php echo e(route('doctor.video-call', $notification->data['appointment_id'])); ?>" class="text-xs sm:text-sm text-green-600 hover:text-green-900">Join Video Call</a>
                                <?php endif; ?>
                            </div>
                        <?php endif; ?>
                        <p class="text-xs text-gray-500 mt-2"><?php echo e($notification->created_at->diffForHumans()); ?></p>
                    </div>
                    <form method="POST" action="<?php echo e(route('doctor.notifications.mark-read', $notification->id)); ?>" class="ml-4">
                        <?php echo csrf_field(); ?>
                        <button type="submit" class="text-gray-400 hover:text-gray-600">
                            <i class="fas fa-times"></i>
                        </button>
                    </form>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
    <?php endif; ?>

    <div class="bg-white rounded-lg shadow p-4 sm:p-6">
        <h2 class="text-lg sm:text-xl font-bold mb-3 sm:mb-4">Recent Appointments</h2>
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-3 sm:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Patient</th>
                        <th class="px-3 sm:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase hidden md:table-cell">Branch</th>
                        <th class="px-3 sm:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Date</th>
                        <th class="px-3 sm:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Status</th>
                        <th class="px-3 sm:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Actions</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    <?php $__currentLoopData = $recentAppointments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $appointment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td class="px-3 sm:px-6 py-4 whitespace-nowrap">
                            <span class="text-sm sm:text-base"><?php echo e($appointment->patient->full_name); ?></span>
                        </td>
                        <td class="px-3 sm:px-6 py-4 whitespace-nowrap hidden md:table-cell">
                            <span class="text-sm"><?php echo e($appointment->branch->name); ?></span>
                        </td>
                        <td class="px-3 sm:px-6 py-4 whitespace-nowrap">
                            <span class="text-xs sm:text-sm"><?php echo e($appointment->appointment_date->format('M d, Y H:i')); ?></span>
                        </td>
                        <td class="px-3 sm:px-6 py-4 whitespace-nowrap">
                            <span class="px-2 py-1 text-xs rounded-full bg-<?php echo e($appointment->status === 'completed' ? 'green' : 'yellow'); ?>-100 text-<?php echo e($appointment->status === 'completed' ? 'green' : 'yellow'); ?>-800">
                                <?php echo e(ucfirst($appointment->status)); ?>

                            </span>
                        </td>
                        <td class="px-3 sm:px-6 py-4 whitespace-nowrap">
                            <?php if($appointment->status !== 'completed'): ?>
                                <a href="<?php echo e(route('prescriptions.create', $appointment->id)); ?>" class="text-blue-600 hover:text-blue-900 text-xs sm:text-sm">
                                    <span class="hidden sm:inline">Create Prescription</span><span class="sm:hidden">Create</span>
                                </a>
                            <?php else: ?>
                                <a href="<?php echo e(route('prescriptions.show', $appointment->prescription->id)); ?>" class="text-green-600 hover:text-green-900 text-xs sm:text-sm">
                                    <span class="hidden sm:inline">View Prescription</span><span class="sm:hidden">View</span>
                                </a>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\BrainTech\Documents\BEAUTEZ SYSTEM\resources\views/doctor/dashboard.blade.php ENDPATH**/ ?>